/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

public class FormatUtils {
    private static final int SECS_PER_HOUR = 3600;
    private static final int SECS_PER_DAY = 86400;
    private static final int SECS_PER_WEEK = 604800;
    private static String[] units = new String[]{"week", "day", "hour", "minutes"};
    private static String[] pluralUnits = new String[]{"weeks", "days", "hours", "minutes"};
    private static int[] divisors = new int[]{604800, 86400, 3600, 60};

    public static String formatMillisecondsAsTimeString(long l) {
        return FormatUtils.formatSecondsAsTimeString((int)l / 1000);
    }

    public static String formatSecondsAsTimeString(int n) {
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        int n4 = n % 60;
        return (n2 < 10 ? "0" : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4;
    }

    public static String formatSecondsAsDescriptiveTimeString(int n) {
        int n2 = n / 3600;
        int n3 = n % 3600 / 60;
        int n4 = n % 60;
        int n5 = 0;
        if (n2 > 0) {
            ++n5;
        }
        if (n3 > 0) {
            ++n5;
        }
        if (n4 > 0) {
            ++n5;
        }
        if (n5 == 0) {
            return "0 seconds";
        }
        if (n5 == 1 || n5 == 2) {
            return FormatUtils.combine(FormatUtils.pluralize(n2, "hour"), " and ", FormatUtils.pluralize(n3, "minute"), " and ", FormatUtils.pluralize(n4, "second"));
        }
        return FormatUtils.pluralize(n2, "hour") + ", " + FormatUtils.pluralize(n3, "minute") + " and " + FormatUtils.pluralize(n4, "second");
    }

    public static String pluralize(int n, String string) {
        return FormatUtils.pluralize(n, string, string + "s", "");
    }

    public static String pluralize(int n, String string, String string2, String string3) {
        if (n == 0) {
            return string3;
        }
        if (n == 1 || n == -1) {
            return n + " " + string;
        }
        return n + " " + string2;
    }

    public static String combine(String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        if (string3 != null && string3.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string3);
        }
        if (string5 != null && string5.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string4);
            }
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    public static String describeDuration(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 3600L;
        long l4 = l2 % 3600L / 60L;
        long l5 = l2 % 60L;
        StringBuffer stringBuffer = new StringBuffer();
        if (l3 > 0L) {
            stringBuffer.append(l3);
            stringBuffer.append(l3 > 1L ? " hours" : " hour");
        }
        if (l4 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(l5 > 0L ? ", " : " and ");
            }
            stringBuffer.append(l4);
            stringBuffer.append(l4 > 1L ? " minutes" : "minute");
        }
        if (l5 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(l3 > 0L && l4 > 0L ? ", and " : " and ");
            }
            stringBuffer.append(l5);
            stringBuffer.append(l5 > 1L ? " seconds" : "second");
        }
        return stringBuffer.toString();
    }

    public static String describeDurationConcisely(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 3600L;
        long l4 = l2 % 3600L / 60L;
        long l5 = l2 % 60L;
        if (l3 >= 1L || l4 >= 10L) {
            l5 = 0L;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (l3 > 0L) {
            stringBuffer.append(l3);
            stringBuffer.append(l3 > 1L ? " hours" : " hour");
        }
        if (l4 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(l5 > 0L ? ", " : " and ");
            }
            stringBuffer.append(l4);
            stringBuffer.append(l4 > 1L ? " minutes" : "minute");
        }
        if (l5 > 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(l3 > 0L && l4 > 0L ? ", and " : " and ");
            }
            stringBuffer.append(l5);
            stringBuffer.append(l5 > 1L ? " seconds" : "second");
        }
        return stringBuffer.toString();
    }

    public static String describeDurationInWeeksThroughMinutes(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < units.length; ++i) {
            int n3 = n / divisors[i];
            if (n3 > 0) {
                if (n2++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(n3).append(' ');
                String string = units[i];
                if (n3 > 1) {
                    string = pluralUnits[i];
                }
                stringBuffer.append(string);
            }
            n %= divisors[i];
        }
        return stringBuffer.length() == 0 ? "1 minute" : stringBuffer.toString();
    }
}

